//
//  MainViewController.m
//  VerticalSwipe
//
//  Created by Gaetano Causio on 13-07-2014.
//  Copyright (c) 2014 Gaetano Causio. All rights reserved.
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  For details over GNU General Public License: http://www.gnu.org/licenses

#import "MainViewController.h"

@interface MainViewController ()

@property (nonatomic, strong) SubViewController *mySubView;
@property (nonatomic, strong) ScrollView *myScrollView;

@end

@implementation MainViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    // Set the size and position of the visible portion of the scroll view (screen size - offset):
    self.myScrollView = [[ScrollView alloc] initWithFrame:CGRectMake(0, SUBVIEW_OFFSET, self.view.frame.size.width, SCREEN_HEIGHT - SUBVIEW_OFFSET)];
    
    
    // Set the content size of the maximum scroll area:
    self.myScrollView.contentSize = CGSizeMake(self.view.frame.size.width, (SCROLL_HEIGHT * 2) - SUBVIEW_OFFSET);
    
    // Scroll view properties
    self.myScrollView.backgroundColor = [UIColor clearColor]; // Transparent view
    self.myScrollView.showsVerticalScrollIndicator = NO;
    self.myScrollView.bounces = YES;
    self.myScrollView.pagingEnabled = YES; // this will automatically move subview to top or bottom when touch is released
    
    // Set the Sub View controller
    self.mySubView = [[SubViewController alloc] init];
    
    // The sub view controller uses different background color than the main view ans it's also slightly transparent
    self.mySubView.view.backgroundColor = [UIColor colorWithRed:0.8 green:0.8 blue:0.8 alpha:0.8];
    
    // Set the position of the sub view at the bottom of the scroll area, so that it can be swiped above it
    self.mySubView.view.frame = CGRectMake(0, SCROLL_HEIGHT - SUBVIEW_OFFSET, self.view.frame.size.width, SCROLL_HEIGHT);
    self.mySubView.delegate = self;
    
    // Add the subview to the scroll view
    [self.myScrollView addSubview:self.mySubView.view];
    
    // Add the scroll view to the main view
    [self.view addSubview:self.myScrollView];
    
    
}

- (void)openCloseButtonPressed
{
    if (self.myScrollView.contentOffset.y) {
        [self.myScrollView setContentOffset:CGPointMake(0, 0) animated:YES];
    } else {
        [self.myScrollView setContentOffset:CGPointMake(0, SCROLL_HEIGHT - SUBVIEW_OFFSET) animated:YES];
    }
}


- (BOOL)shouldAutorotate
{
    return NO;
}

@end
